package gov.va.med.mhv.calendar.repository;

import java.util.Date;
import java.util.List;

import gov.va.med.mhv.calendar.model.ToDoTask;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ToDoTaskRepository extends JpaRepository<ToDoTask, Long>  {
	
	@Query("select calTask from ToDoTask calTask " +
			   "where calTask.userProfileId = :userProfileId " +
				"order by calTask.dueDate asc  NULLS LAST")
		public List<ToDoTask> getToDosForUser(@Param("userProfileId") Long userProfileId);
	
	
	
	@Query("select calTask from ToDoTask calTask " +
			   "where calTask.userProfileId = :userProfileId and " + 
			   "(upper(subject) LIKE upper(:keyword) or upper(description) LIKE upper(:keyword)) " +
				"order by calTask.dueDate, calTask.subject asc")
		public List<ToDoTask> searchToDosForUser(@Param("userProfileId") Long userProfileId,@Param("keyword") String keyword);

	
	@Query("select calTask from ToDoTask calTask " +
			   "where calTask.userProfileId = :userProfileId " +
			   "and calTask.toDoStatus = :filter " +
				"order by calTask.dueDate desc  NULLS LAST")
	public List<ToDoTask> getFilteredToDosForUser(@Param("userProfileId") Long userProfileId, @Param("filter") String filter);

	@Query("select calTask from ToDoTask calTask " +
			   "where calTask.userProfileId = :userProfileId " +
			   "and calTask.dueDate < CURRENT_DATE " +
			   "and calTask.toDoStatus != :filter " +
				"order by calTask.dueDate, calTask.subject asc")
	public List<ToDoTask> getOverdueToDosForUser(@Param("userProfileId") Long userProfileId, @Param("filter") String filter);
	

	@Query("select calTask from ToDoTask calTask, UserCalView as userCalView " +
			"where (userCalView.visn.visnId = :visnId " +
			"and calTask.userProfileId = userCalView.userProfileId " + 
			"and calTask.reminderDate = :reminderDate) " +
			"order by calTask.reminderDate asc " )
	public List<ToDoTask> getAllTaskRemindersByVisn(@Param("visnId") Long visnId, @Param("reminderDate") Date reminderDate);


	@Query("select calTask from ToDoTask calTask " +
			   "where calTask.userProfileId = :userProfileId " +
			   "and upper(calTask.subject) like upper(:keyword) " +
			   "and calTask.toDoStatus != :filter " +
			   "order by calTask.dueDate desc NULLS LAST")
	public List<ToDoTask> findToDosForUser(@Param("userProfileId") Long userProfileId, @Param("keyword") String keyword);
	
}
